#include "../../common/buffer.h"
#include "../../common/colors.h"
#include "../../parse/parser.h"
#include "../shaders.h"
#include <stdlib.h>

int _init_hilight(void **data_ptr, char *input)
{
	void* data = malloc(sizeof(int));
	
	if(assign_int(data, input) == 0)
	{
		free(data);
		return 0;
	}
	
	*data_ptr = (void*)data;
	return 1;
}

void _run_hilight(void *data)
{
	static int num;
	static unsigned char *frame;
	static intersect_data *buffer;
	static intersect_data *idata;
	static color c;
	static int x,y;

	num = *(int*)data;
	buffer = main_scene->intersect_buffer;
	frame = main_scene->frame_buffer;

	for(y = 0; y < main_scene->height; y++)
	{
		for(x = 0; x < main_scene->width; x++)
		{
			idata = get_idata(x, y);
			
			if(idata->obj_num != num)
			{
				get_color(x, y, &c);
				multiply_color(&c, 0.25);
				set_color(x, y, &c);
			}
		}
	}
}

void _cleanup_hilight(void* data)
{
	free((int*)data);
}


shader_data hilight =
{
	"hilight",
	"options:\n   hilight <int objnum>\n",
	(int (*)(void*, char*))_init_hilight,
	(void* (*)(void*))_run_hilight,
	(void* (*)(void*))_cleanup_hilight,
};

shader_data* get_hilight()
{
	return &hilight;
}


